#ifndef CE2_UTIL_RSA_SCHEMES_H
#define CE2_UTIL_RSA_SCHEMES_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/
#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object %CE2_UTIL_RSA_SCHEMES.h    : %
*  State           :  %state%
*  Creation date   :  %date%
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief This module defines the API that supports PKCS#1 v1.5 and PKCS#1 v2.1 schemes
*
*  \version CE2_UTIL_RSA_SCHEMES.h#1:incl:1
*  \author ronys ohads
*  \remarks Copyright (C) 2001-2007 by Discretix Technologies Ltd. All Rights reserved.
*/

/************************ Defines *****************************/
/************************ Enums *******************************/

//CE2_DX_RSA_SCHEMES_WrongEncrypt error types
enum PKCS1_V15_EncodeErrorTypes{
	PKCS1_V15_EncodeErrorDisableRandomGenerator =	1 << 0,
	PKCS1_V15_EncodeErrorDontAdd0AtTheBegining =	1 << 1,
	PKCS1_V15_EncodeErrorDontAdd2AtTheBegining =	1 << 2,
	PKCS1_V15_EncodeErrorDisableRemoveZeros =		1 << 3,
};
enum PKCS1_V21_EncodeErrorTypes{
	PKCS1_V21_EncodeErrorDisableRandomGenerator =	1 << 0,
	PKCS1_V21_EncodeErrorDisableAppendPSToLhash	=	1 << 1,
	PKCS1_V21_EncodeErrorDontAdd0x01ToLhash		=	1 << 2,
	PKCS1_V21_EncodeErrorDisableXORagainstSeed	=	1 << 3,
};

//CE2_DX_RSA_WrongSign error types
/* packet is 0x00 0x01 PS 0x00 T, where PS == 0xFF repeated modulus_bytelen - 3 - OIDlen - msghashlen times, T == DER || hash */
enum PKCS1_V15_SaEncodeErrorTypes{
	PKCS1_V15_SaEncodeErrorDontAdd0AtTheBegining =	1 << 0,
	PKCS1_V15_SaEncodeErrorDontAdd1AtTheBegining =	1 << 1,
	PKCS1_V15_SaEncodeErrorDontAddHAshDescriptor =	1 << 2,
};
enum PKCS1_V21_SaEncodeErrorTypes{
	PKCS1_V21_SaEncodeErrorDontAddEight0x00AtTheBegining =	1 << 0,
	PKCS1_V21_SaEncodeErrorDontAddMsgHash =					1 << 1,
	PKCS1_V21_SaEncodeErrorDontAddHash =					1 << 2,
};
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private function prototype **********/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  CE2_DX_RSA_SCHEMES_WrongEncrypt
*
* Inputs:
*  @param UserPubKey_ptr [in] - A pointer to the public key data structure of the User;
*  @param hashFunc       [in] - The hash function to be used;
*         Currently only CE2_PKCS1_SHA1 is supported. 
*         The other hash functions recommended 
*         by PKCS#1 v2.1 are SHA-256/284/512.
*  @param L              [in] - The label input;
*         Version 2.1 of the standard defines L as the empty string, 
*         so this argument is currently ignored. 
*  @param Llen           [in] - The label length;
*         Version 2.1 of the standard defines L as the empty string, 
*         so this argument is currently ignored.
*  @param MGF            [in] - The mask generation function. PKCS#1 v2.1 defines MGF1, 
*         so the only value allowed here is CE2_PKCS1_MGF1;
*  @param DataIn_ptr     [in] - A pointer to the data to encrypt;
*  @param DataInSize       [in] - The size, in bytes, of the data to encrypt;
*         \note Must be <= (modulus_size - 2*Hash_output_length - 2).
*  @param Output_ptr     [out] - A pointer to the encrypted data;
*         The buffer must be at least PubKey_ptr->N.len bytes long 
*         (that is, the size of the modulus, in bytes).
*  @param errorSchemetype [in] - Send type of error for Encryption algorithm
*  @param PKCS1_ver      [in] - Ver 1.5 or 2.1, according to the functionality required.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_BAD_PARAM,
*     - CE2_OUT_OF_RANGE.
*
***************************************************************/

CE2CIMPORT_C CE2Error_t CE2_DX_RSA_SCHEMES_WrongEncrypt(CE2_RSAUserPubKey_t *UserPubKey_ptr,
														CE2_RSA_HASH_OpMode_t hashFunc,
														DxUint8_t *L,
														DxUint16_t Llen,
														CE2_PKCS1_MGF_t MGF,
														DxUint8_t *DataIn_ptr,
														DxUint16_t DataInSize,
														DxUint8_t *Output_ptr,
														DxUint32_t errorSchemetype,
														CE2_PKCS1_version PKCS1_ver);
/**
****************************************************************
* Function Name: 
*  CE2_DX_RSA_WrongSign
*
* Inputs:
*  @param UserPrivKey_ptr [in] - A pointer to the private key data
*         structure of the user;
*         \note The representation
*         (pair or quintuple) and hence the
*         algorithm (CRT or not) is determined
*         by the Private Key data
*         structure - using CE2_Build_PrivKey
*         or CE2_Build_PrivKeyCRT determines
*         which algorithm will be used.
*  @param hashFunc        [in] - The hash function to be used;
*         Currently only CE2_PKCS1_SHA1 and CE2_PKCS1_MD5 are supported.
*  @param MGF             [in] - The mask generation function;
*         Only for PKCS#1 v2.1 defines MGF1,
*         so the only value allowed for v2.1 is CE2_PKCS1_MGF1.
*  @param SaltLen         [in] - The Length of the Salt buffer;
*         Typical lengths are 0 and hLen (20 for SHA1)
*         The maximum length allowed is NSize - hLen - 2
*  @param DataIn_ptr      [in] - A pointer to the data to sign;
*  @param DataInSize      [in] - The size, in bytes, of the data to sign;
*  @param Output_ptr      [out] - A pointer to the signature;
*         The buffer must be at least PrivKey_ptr->N.len bytes long 
*         (that is, the size of the modulus in bytes).
*  @param OutputSize_ptr  [in/out] - A pointer to the Signature Size value -
*         the input value is the signature buffer size allocated, the output value is 
*         the signature size actually used.
*         The buffer must be at least PrivKey_ptr->N.len bytes long 
*         (that is, the size of the modulus in bytes).
*  @param errorSchemetype [in] - Send type of error for Sign algorithm
*  @param PKCS1_ver       [in] - Ver 1.5 or 2.1, according to the functionality required.
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*     - CE2_RSA_INVALID_PRIV_KEY_STRUCT_POINTER_ERROR,
*     - CE2_RSA_PRIV_KEY_VALIDATION_TAG_ERROR,
*     - CE2_RSA_HASH_ILLEGAL_OPERATION_MODE_ERROR,
*     - CE2_RSA_MGF_ILLEGAL_ARG_ERROR,
*     - CE2_RSA_PKCS1_VER_ARG_ERROR,
*     - CE2_RSA_INVALID_MESSAGE_DATA_SIZE,
*     - CE2_RSA_INVALID_OUTPUT_POINTER_ERROR,
*     - CE2_RSA_INVALID_SIGNATURE_BUFFER_SIZE.
*
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_DX_RSA_WrongSign(CE2_RSAUserPrivKey_t *UserPrivKey_ptr,
										CE2_RSA_HASH_OpMode_t hashFunc,
										CE2_PKCS1_MGF_t MGF,
										DxUint16_t SaltLen,				  			      
										DxUint8_t *DataIn_ptr,
										DxUint32_t DataInSize,
										DxUint8_t *Output_ptr,
										DxUint16_t *OutputSize_ptr,
										DxUint32_t errorSchemetype,
										CE2_PKCS1_version PKCS1_ver);

#ifdef __cplusplus
}
#endif			

#endif /* CE2_UTIL_RSA_SCHEMES_H */
